# 🎯 PANDUAN FINAL - Fitur Lupa Password (Admin Only)

## ✅ SISTEM SUDAH BENAR!

---

## 📍 ATURAN SISTEM:

### **ADMIN** 🔐
- ✅ **Bisa lupa password**
- ✅ Masukkan email → Dapat link reset
- ✅ Klik link → Ganti password
- ✅ Login dengan password baru

### **KASIR** 👤
- ❌ **TIDAK ada fitur lupa password**
- ✅ Jika lupa password → **Tanya admin**
- ✅ Admin yang reset password kasir

---

## 🚀 FITUR LUPA PASSWORD (ADMIN ONLY):

### **Cara Kerja:**

1. **Admin klik "Lupa Password?" di halaman login**
   ```
   http://localhost/sim_toko2/login.php
   ```

2. **Masukkan email admin**
   ```
   http://localhost/sim_toko2/lupa_password.php
   ```

3. **Link reset password muncul di layar**
   ```
   Contoh:
   ✅ Link reset password telah dibuat!
   
   Klik link berikut untuk reset password:
   http://localhost/sim_toko2/reset_password.php?token=abc123...
   
   Link berlaku selama 1 jam.
   ```

4. **Klik link tersebut**

5. **Masukkan password baru**
   - Password minimal 6 karakter
   - Konfirmasi password

6. **Login dengan password baru**

---

## 👤 JIKA KASIR LUPA PASSWORD:

### **Kasir harus:**
1. **Tanya admin** untuk reset password
2. Admin akan reset password kasir
3. Admin beritahu password baru ke kasir
4. Kasir login dengan password baru

### **Admin reset password kasir via:**

**METODE 1: Via Database (phpMyAdmin)**
```sql
-- Lihat daftar kasir
SELECT id_user, username, role FROM users WHERE role='kasir';

-- Reset password kasir (password: kasir123)
UPDATE users 
SET password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    password_text = 'kasir123'
WHERE username = 'nama_kasir' AND role = 'kasir';
```

**METODE 2: Via File Darurat (Emergency)**
```
http://localhost/sim_toko2/reset_kasir_darurat.php
```
⚠️ **HAPUS file ini setelah selesai!**

---

## 📋 SETUP AWAL (Sekali Saja):

### **1. Update Email Admin**

Agar fitur lupa password berfungsi, admin harus punya email:

**Di phpMyAdmin, jalankan:**
```sql
UPDATE users 
SET email = 'admin@perusahaan.com' 
WHERE role = 'admin';
```

Ganti `admin@perusahaan.com` dengan email admin yang sebenarnya.

**Verifikasi:**
```sql
SELECT id_user, username, email, role FROM users WHERE role='admin';
```

---

## 🧪 TEST FITUR LUPA PASSWORD:

### **Langkah Test:**

1. **Buka halaman login:**
   ```
   http://localhost/sim_toko2/login.php
   ```

2. **Klik "🔐 Lupa Password? (Admin)"**

3. **Masukkan email admin** (yang sudah diset di database)

4. **Klik "Kirim Link Reset Password"**

5. **Lihat hasilnya:**
   - ✅ Link reset password muncul di layar
   - Copy link tersebut

6. **Klik atau paste link di browser**

7. **Masukkan password baru:**
   - Password baru: (minimal 6 karakter)
   - Konfirmasi password: (sama dengan di atas)

8. **Klik "Simpan Password Baru"**

9. **Login dengan password baru**

---

## ✅ CHECKLIST:

### Setup (Sekali Saja):
- [ ] Update email admin di database
- [ ] Verifikasi email admin sudah tersimpan
- [ ] Test fitur lupa password
- [ ] Pastikan link reset muncul
- [ ] Pastikan bisa ganti password
- [ ] Pastikan bisa login dengan password baru

### Untuk Admin yang Lupa Password:
- [ ] Klik "Lupa Password?" di login
- [ ] Masukkan email admin
- [ ] Copy link reset yang muncul
- [ ] Klik link reset
- [ ] Masukkan password baru
- [ ] Login dengan password baru

### Untuk Kasir yang Lupa Password:
- [ ] Kasir tanya admin
- [ ] Admin reset password kasir
- [ ] Admin beritahu password baru
- [ ] Kasir login dengan password baru

---

## 📊 ALUR SISTEM:

### **Admin Lupa Password:**
```
Admin lupa password
    ↓
Klik "Lupa Password?" di login
    ↓
Masukkan email admin
    ↓
Link reset muncul di layar ✨
    ↓
Klik link reset
    ↓
Masukkan password baru
    ↓
Konfirmasi password
    ↓
Password tersimpan
    ↓
Login dengan password baru
```

### **Kasir Lupa Password:**
```
Kasir lupa password
    ↓
Tanya admin
    ↓
Admin reset password kasir
    ↓
Admin beritahu password baru
    ↓
Kasir login dengan password baru
```

---

## 🔒 KEAMANAN:

### **Token Reset Password:**
- ✅ Random 64 karakter (sangat aman)
- ✅ Berlaku 1 jam saja
- ✅ Hanya bisa dipakai sekali
- ✅ Tersimpan di database dengan expired time

### **Validasi:**
- ✅ Email harus terdaftar sebagai admin
- ✅ Token harus valid dan belum expired
- ✅ Password minimal 6 karakter
- ✅ Password dan konfirmasi harus sama

---

## 📁 FILE YANG DIGUNAKAN:

| File | Fungsi | Untuk |
|------|--------|-------|
| `login.php` | Halaman login | Semua user |
| `lupa_password.php` | Lupa password | **Admin only** |
| `reset_password.php` | Ganti password via link | **Admin only** |
| `reset_kasir_darurat.php` | Reset password kasir | Admin (darurat) |
| `reset_admin_darurat.php` | Reset password admin | Admin (darurat) |

---

## 🆘 TROUBLESHOOTING:

### Email admin tidak ditemukan:
```sql
-- Cek email admin
SELECT * FROM users WHERE role='admin';

-- Update email admin
UPDATE users SET email='admin@perusahaan.com' WHERE role='admin';
```

### Token kadaluarsa:
- Request reset password lagi
- Token berlaku 1 jam
- Gunakan link secepatnya

### Link tidak bisa diklik:
- Copy link manual
- Paste di address bar browser
- Tekan Enter

### Password tidak bisa disimpan:
- Pastikan password minimal 6 karakter
- Pastikan password dan konfirmasi sama
- Cek apakah ada error di halaman

---

## 🎉 KESIMPULAN:

### **Sistem yang Benar:**
- ✅ **Fitur lupa password HANYA untuk ADMIN**
- ✅ **Kasir TIDAK ada fitur lupa password**
- ✅ **Kasir lupa password → Tanya admin**
- ✅ **Link reset muncul di layar (tidak perlu email)**
- ✅ **Token aman dan expired 1 jam**

### **Keunggulan:**
- ✅ Tidak perlu setup SMTP/email server
- ✅ Link langsung muncul di layar
- ✅ Cepat dan praktis
- ✅ Aman dengan token random
- ✅ Sederhana dan mudah digunakan
- ✅ **Link otomatis menyesuaikan domain (localhost/hosting)**
- ✅ **Siap untuk hosting tanpa perlu ubah kode**

---

## 🚀 LANGKAH SELANJUTNYA:

1. **Update email admin di database** (jika belum)
2. **Test fitur lupa password**
3. **Pastikan semua berfungsi**
4. **Hapus file darurat** (reset_kasir_darurat.php, reset_admin_darurat.php)

---

**Apakah sudah jelas sekarang?**  
**Perlu bantuan untuk test fitur lupa password?** 😊

---

Dibuat: 30 Januari 2026, 09:19 WIB  
Status: ✅ FINAL & BENAR  
Fitur: Lupa Password (Admin Only)
