<?php
session_start();
include "../koneksi.php";

if (!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir') {
    header("Location: ../login.php");
    exit;
}

if (!isset($_POST['kasir'])) {
    header("Location: transaksi.php");
    exit;
}

$kasir = $_POST['kasir'];
$tanggal = $_POST['tanggal'];
$bayar_raw = $_POST['bayar'];
$bayar = intval(preg_replace('/\D/', '', $bayar_raw));
$total_belanja = 0;
$items = [];

// Proses item yang dipilih
if (isset($_POST['qty'])) {
    foreach ($_POST['qty'] as $id_produk => $qty) {
        $qty = intval($qty);
        if ($qty > 0) {
            $q = mysqli_query($koneksi, "SELECT * FROM produk WHERE id_produk='$id_produk'");
            $p = mysqli_fetch_assoc($q);
            
            $subtotal = $p['harga'] * $qty;
            $total_belanja += $subtotal;
            
            $items[] = [
                'id_produk' => $id_produk,
                'nama' => $p['nama_produk'],
                'harga' => $p['harga'],
                'qty' => $qty,
                'subtotal' => $subtotal
            ];
        }
    }
}

$kembalian = $bayar - $total_belanja;
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Preview Transaksi</title>
<style>
body{font-family:'Segoe UI',sans-serif;background:#f4f6f9;padding:20px;}
.container{max-width:700px;margin:auto;background:#fff;padding:25px;border-radius:10px;box-shadow:0 5px 20px rgba(0,0,0,0.1);}
h2{text-align:center;color:#2c3e50;margin-bottom:20px;}
table{width:100%;border-collapse:collapse;margin-bottom:20px;}
th,td{padding:10px;text-align:center;border:1px solid #ddd;}
th{background:#2c3e50;color:#fff;}
tfoot td{font-weight:bold;}
.btn{display:inline-block;background:#27ae60;color:#fff;padding:10px 15px;border-radius:6px;text-decoration:none;border:none;cursor:pointer;margin-top:10px;font-size:14px;}
.btn:hover{background:#219150;}
.btn-back{background:#e74c3c;}
.btn-back:hover{background:#c0392b;}
.btn-group{text-align:center; margin-top:20px;}
</style>
</head>
<body>

<div class="container">
    <h2>Konfirmasi Transaksi</h2>
    <p><strong>Kasir:</strong> <?= htmlspecialchars($kasir) ?></p>
    <p><strong>Tanggal:</strong> <?= date('Y-m-d', strtotime($tanggal)) ?></p>

    <table>
        <thead>
            <tr><th>Produk</th><th>Qty</th><th>Harga</th><th>Subtotal</th></tr>
        </thead>
        <tbody>
            <?php foreach ($items as $item): ?>
            <tr>
                <td><?= htmlspecialchars($item['nama']) ?></td>
                <td><?= $item['qty'] ?></td>
                <td>Rp <?= number_format($item['harga'], 0, ',', '.') ?></td>
                <td>Rp <?= number_format($item['subtotal'], 0, ',', '.') ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr><td colspan="3">Total</td><td>Rp <?= number_format($total_belanja, 0, ',', '.') ?></td></tr>
            <tr><td colspan="3">Bayar</td><td>Rp <?= number_format($bayar, 0, ',', '.') ?></td></tr>
            <tr><td colspan="3">Kembalian</td><td>Rp <?= number_format($kembalian, 0, ',', '.') ?></td></tr>
        </tfoot>
    </table>

    <form action="transaksi_proses.php" method="POST">
        <input type="hidden" name="kasir" value="<?= htmlspecialchars($kasir) ?>">
        <input type="hidden" name="tanggal" value="<?= htmlspecialchars($tanggal) ?>">
        <input type="hidden" name="bayar" value="<?= $bayar ?>">
        
        <?php foreach ($items as $item): ?>
            <input type="hidden" name="qty[<?= $item['id_produk'] ?>]" value="<?= $item['qty'] ?>">
        <?php endforeach; ?>

        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-back">← Edit / Kembali</a>
            <?php if ($kembalian >= 0 && count($items) > 0): ?>
                <button type="submit" class="btn">Proses & Cetak Struk</button>
            <?php else: ?>
                <button type="button" class="btn" style="background:#95a5a6;cursor:not-allowed;">Tidak Bisa Proses</button>
            <?php endif; ?>
        </div>
    </form>
</div>

</body>
</html>
