<?php
/**
 * LUPA PASSWORD - Versi Sederhana
 * Admin masukkan email → Dapat link reset password
 */

include "koneksi.php";

$msg = "";
$msg_type = "";

if(isset($_POST['kirim'])){
    $email = mysqli_real_escape_string($koneksi, $_POST['email']);

    // Cek apakah email terdaftar sebagai admin
    $q = mysqli_query($koneksi,
        "SELECT * FROM users WHERE email='$email' AND role='admin'"
    );

    if(mysqli_num_rows($q) > 0){
        $user = mysqli_fetch_assoc($q);

        // Generate token unik
        $token = bin2hex(random_bytes(32));
        $expired = date('Y-m-d H:i:s', strtotime('+1 hour')); // Token berlaku 1 jam

        // Simpan token ke database
        mysqli_query($koneksi, "UPDATE users SET 
            reset_token='$token',
            reset_expired='$expired'
            WHERE id_user='".$user['id_user']."'");

        // Link reset password - DINAMIS (otomatis menyesuaikan domain)
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $script_path = dirname($_SERVER['PHP_SELF']);
        $reset_link = $protocol . "://" . $host . $script_path . "/reset_password.php?token=$token";

        $msg = "✅ Link reset password telah dibuat!<br><br>";
        $msg .= "<strong>Klik link berikut untuk reset password:</strong><br>";
        $msg .= "<a href='$reset_link' style='color: #2196F3; font-size: 16px;'>$reset_link</a><br><br>";
        $msg .= "<small style='color: #666;'>Link berlaku selama 1 jam.</small>";
        $msg_type = "success";

    } else {
        $msg = "❌ Email admin tidak ditemukan dalam sistem.";
        $msg_type = "error";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lupa Password - SIM Toko</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 500px;
            width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #333;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #666;
            font-size: 14px;
        }
        
        .icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 40px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        
        input[type="email"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 15px;
            transition: all 0.3s;
        }
        
        input[type="email"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        button {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        button:active {
            transform: translateY(0);
        }
        
        .message {
            margin-top: 20px;
            padding: 15px;
            border-radius: 8px;
            font-size: 14px;
            line-height: 1.8;
        }
        
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .message a {
            color: #2196F3;
            text-decoration: none;
            word-break: break-all;
        }
        
        .message a:hover {
            text-decoration: underline;
        }
        
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
            transition: color 0.3s;
        }
        
        .back-link a:hover {
            color: #764ba2;
            text-decoration: underline;
        }
        
        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-size: 13px;
            color: #0d47a1;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="icon">🔐</div>
            <h1>Lupa Password</h1>
            <p>Masukkan email untuk reset password</p>
        </div>
        
        <div class="info-box">
            ℹ️ Anda akan mendapatkan link untuk reset password. Link berlaku selama 1 jam.
        </div>
        
        <form method="POST">
            <div class="form-group">
                <label for="email">Email Admin</label>
                <input 
                    type="email" 
                    id="email"
                    name="email" 
                    placeholder="" 
                    required
                    autocomplete="email"
                >
            </div>
            
            <button type="submit" name="kirim">
                📧 Kirim Link Reset Password
            </button>
        </form>
        
        <?php if($msg): ?>
        <div class="message <?= $msg_type ?>">
            <?= $msg ?>
        </div>
        <?php endif; ?>
        
        <div class="back-link">
            <a href="login.php">← Kembali ke Login</a>
        </div>
    </div>
</body>
</html>
